/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.client.gui;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import compasses.expandedstorage.impl.CommonClient;
import compasses.expandedstorage.impl.client.function.ScreenSize;
import compasses.expandedstorage.impl.client.gui.CopyFunction;
import compasses.expandedstorage.impl.client.gui.FakePickScreen;
import compasses.expandedstorage.impl.client.gui.MiniStorageScreen;
import compasses.expandedstorage.impl.client.gui.PageScreen;
import compasses.expandedstorage.impl.client.gui.PickScreen;
import compasses.expandedstorage.impl.client.gui.ScrollScreen;
import compasses.expandedstorage.impl.client.gui.SingleScreen;
import compasses.expandedstorage.impl.client.gui.SizedSimpleTexture;
import compasses.expandedstorage.impl.client.helpers.ErrorlessTextureGetter;
import compasses.expandedstorage.impl.inventory.handler.AbstractHandler;
import compasses.expandedstorage.impl.misc.Utils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractScreen
extends AbstractContainerScreen<AbstractHandler> {
    protected final int inventoryWidth;
    protected final int inventoryHeight;
    protected final int totalSlots;
    protected final ResourceLocation textureLocation;
    protected final int textureWidth;
    protected final int textureHeight;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AbstractScreen(AbstractHandler handler, Inventory playerInventory, Component title, ScreenSize screenSize) {
        super((AbstractContainerMenu)handler, playerInventory, title);
        this.totalSlots = handler.getInventory().m_6643_();
        this.inventoryWidth = screenSize.getWidth();
        this.inventoryHeight = screenSize.getHeight();
        ResourceLocation resourceLocation = this.textureLocation = this instanceof MiniStorageScreen ? Utils.id("textures/gui/container/mini_chest_screen.png") : Utils.id("textures/gui/container/shared_" + this.inventoryWidth + "_" + this.inventoryHeight + ".png");
        if (!(this instanceof FakePickScreen)) {
            AbstractTexture texture;
            boolean isTexturePresent = ((ErrorlessTextureGetter)Minecraft.m_91087_().m_91097_()).expandedstorage$isTexturePresent(this.textureLocation);
            if (!isTexturePresent && !(this instanceof MiniStorageScreen)) {
                int guiWidth = 36 + 18 * this.inventoryWidth;
                int guiHeight = 132 + 18 * this.inventoryHeight;
                int textureWidth = (int)(Math.ceil((float)guiWidth / 16.0f) * 16.0);
                int textureHeight = (int)(Math.ceil((float)guiHeight / 16.0f) * 16.0);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)Utils.id("textures/gui/container/atlas_gen.png"));
                RenderSystem.bindTexture((int)RenderSystem.getShaderTexture((int)0));
                try (NativeImage atlas = new NativeImage(96, 96, false);){
                    atlas.m_85045_(0, false);
                    try (NativeImage image = new NativeImage(textureWidth, textureHeight, false);){
                        image.m_84997_(0, 0, textureWidth, textureHeight, 0xFFFFFF);
                        AbstractScreen.renderGui(this.inventoryWidth, this.inventoryHeight, (destX, destY, w, h, srcX, srcY) -> atlas.m_260930_(image, srcX, srcY, destX, destY, w, h, false, false));
                        DynamicTexture texture2 = new DynamicTexture(image);
                        Minecraft.m_91087_().m_91097_().m_118495_(this.textureLocation, (AbstractTexture)texture2);
                    }
                }
            }
            if ((texture = Minecraft.m_91087_().m_91097_().m_118506_(this.textureLocation)) instanceof DynamicTexture) {
                DynamicTexture dynamicTexture = (DynamicTexture)texture;
                this.textureWidth = dynamicTexture.m_117991_().m_84982_();
                this.textureHeight = dynamicTexture.m_117991_().m_85084_();
                return;
            } else {
                if (!(texture instanceof SizedSimpleTexture)) throw new IllegalStateException();
                SizedSimpleTexture simpleTexture = (SizedSimpleTexture)texture;
                this.textureWidth = simpleTexture.getWidth();
                this.textureHeight = simpleTexture.getHeight();
            }
            return;
        }
        this.textureWidth = 0;
        this.textureHeight = 0;
    }

    public static void renderGui(int inventoryWidth, int inventoryHeight, CopyFunction function) {
        int x;
        int x2;
        int x3;
        function.apply(0, 0, 7, 17, 1, 1);
        for (x3 = 0; x3 < inventoryWidth; ++x3) {
            function.apply(7 + x3 * 18, 0, 18, 17, 9, 1);
        }
        function.apply(7 + inventoryWidth * 18, 0, 7, 17, 28, 1);
        function.apply(7 + inventoryWidth * 18 + 7, 0, 22, 17, 36, 1);
        for (int y = 0; y < inventoryHeight; ++y) {
            int scollbarYOffset = y == 0 ? 19 : (y == inventoryHeight - 1 ? 57 : 38);
            function.apply(0, 17 + 18 * y, 7, 18, 1, 19);
            for (x2 = 0; x2 < inventoryWidth; ++x2) {
                function.apply(7 + 18 * x2, 17 + 18 * y, 18, 18, 9, 19);
            }
            function.apply(7 + 18 * inventoryWidth, 17 + 18 * y, 7, 18, 28, 19);
            function.apply(7 + 18 * inventoryWidth + 7, 17 + 18 * y, 22, 18, 36, scollbarYOffset);
        }
        function.apply(0, 17 + 18 * inventoryHeight, 7, 14, 1, 38);
        for (x3 = 0; x3 < inventoryWidth; ++x3) {
            function.apply(7 + 18 * x3, 17 + 18 * inventoryHeight, 18, 14, 9, 38);
        }
        function.apply(7 + 18 * inventoryWidth, 17 + 18 * inventoryHeight, 7, 14, 28, 38);
        if (inventoryWidth > 9) {
            function.apply(7 + 18 * inventoryWidth + 7, 17 + 18 * inventoryHeight, 22, 17, 59, 76);
            function.apply(7 + 18 * inventoryWidth + 7, 17 + 18 * inventoryHeight + 17, 12, 15, 59, 1);
        } else {
            function.apply(7 + 18 * inventoryWidth + 7, 17 + 18 * inventoryHeight, 22, 7, 36, 76);
            function.apply(7 + 18 * inventoryWidth + 7, 17 + 18 * inventoryHeight + 7, 12, 15, 59, 1);
        }
        if (inventoryWidth > 9) {
            function.apply(0, 17 + 18 * inventoryHeight + 7 + 3, 7, 7, 1, 58);
            int sideParts = (int)Math.ceil((float)(inventoryWidth - 9) / 2.0f);
            for (int i = 0; i < sideParts; ++i) {
                function.apply(7 + 18 * i, 17 + 18 * inventoryHeight + 7 + 3, 18, 7, 9, 58);
                function.apply(7 + 18 * (inventoryWidth - i - 1), 17 + 18 * inventoryHeight + 7 + 3, 18, 7, 9, 58);
            }
            function.apply(7 + 18 * inventoryWidth, 17 + 18 * inventoryHeight + 7 + 3, 7, 7, 28, 58);
        }
        int startX = (int)((float)(inventoryWidth - 9) / 2.0f * 18.0f);
        for (int y = 0; y < 3; ++y) {
            function.apply(startX, 17 + 18 * (inventoryHeight + y) + 14, 7, 18, 1, 19);
            for (x2 = 0; x2 < 9; ++x2) {
                function.apply(startX + 7 + 18 * x2, 17 + 18 * (inventoryHeight + y) + 14, 18, 18, 9, 19);
            }
            function.apply(startX + 7 + 162, 17 + 18 * (inventoryHeight + y) + 14, 7, 18, 28, 19);
        }
        function.apply(startX, 17 + 18 * (inventoryHeight + 3) + 14, 7, 4, 1, 53);
        function.apply(startX, 17 + 18 * (inventoryHeight + 3) + 14 + 4, 7, 18, 1, 19);
        function.apply(startX, 17 + 18 * (inventoryHeight + 4) + 14 + 4, 7, 7, 1, 58);
        for (x = 0; x < 9; ++x) {
            function.apply(startX + 7 + 18 * x, 17 + 18 * (inventoryHeight + 3) + 14, 18, 4, 9, 53);
            function.apply(startX + 7 + 18 * x, 17 + 18 * (inventoryHeight + 3) + 14 + 4, 18, 18, 9, 19);
            function.apply(startX + 7 + 18 * x, 17 + 18 * (inventoryHeight + 4) + 14 + 4, 18, 7, 9, 58);
        }
        function.apply(startX + 7 + 162, 17 + 18 * (inventoryHeight + 3) + 14, 7, 4, 28, 53);
        function.apply(startX + 7 + 162, 17 + 18 * (inventoryHeight + 3) + 14 + 4, 7, 18, 28, 19);
        function.apply(startX + 7 + 162, 17 + 18 * (inventoryHeight + 4) + 14 + 4, 7, 7, 28, 58);
        if (inventoryWidth > 9) {
            function.apply(startX, 17 + 18 * inventoryHeight + 14, 3, 3, 20, 66);
            function.apply(startX + 162 + 11, 17 + 18 * inventoryHeight + 14, 3, 3, 24, 66);
        }
        for (x = 0; x < inventoryWidth; ++x) {
            function.apply(7 + 18 * x, 17 + 18 * (inventoryHeight + 4) + 14 + 4 + 7, 18, 18, 1, 66);
        }
    }

    public static AbstractScreen createScreen(AbstractHandler handler, Inventory playerInventory, Component title) {
        ResourceLocation forcedScreenType = handler.getForcedScreenType();
        ResourceLocation preference = forcedScreenType != null ? forcedScreenType : CommonClient.platformHelper().configWrapper().getPreferredScreenType();
        int scaledWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        int scaledHeight = Minecraft.m_91087_().m_91268_().m_85446_();
        int slots = handler.getInventory().m_6643_();
        if (forcedScreenType == null && AbstractScreen.canSingleScreenDisplay(slots, scaledWidth, scaledHeight) && AbstractScreen.shouldPreferSingleScreen(preference)) {
            preference = Utils.SINGLE_SCREEN_TYPE;
        }
        if (preference == null) {
            return new FakePickScreen(handler, playerInventory, title);
        }
        ScreenSize screenSize = AbstractScreen.getScreenSize(preference, slots, scaledWidth, scaledHeight);
        if (screenSize == null) {
            throw new IllegalStateException("screenSize should never be null...");
        }
        if (Utils.PAGINATED_SCREEN_TYPE.equals((Object)preference)) {
            return new PageScreen(handler, playerInventory, title, screenSize);
        }
        if (Utils.SCROLLABLE_SCREEN_TYPE.equals((Object)preference)) {
            return new ScrollScreen(handler, playerInventory, title, screenSize);
        }
        if (Utils.SINGLE_SCREEN_TYPE.equals((Object)preference)) {
            return new SingleScreen(handler, playerInventory, title, screenSize);
        }
        if (Utils.MINI_STORAGE_SCREEN_TYPE.equals((Object)preference)) {
            return new MiniStorageScreen(handler, playerInventory, title, screenSize);
        }
        throw new IllegalArgumentException("Unknown preference.");
    }

    private static boolean shouldPreferSingleScreen(ResourceLocation type) {
        return Utils.PAGINATED_SCREEN_TYPE.equals((Object)type) || Utils.SCROLLABLE_SCREEN_TYPE.equals((Object)type);
    }

    private static boolean canSingleScreenDisplay(int slots, int scaledWidth, int scaledHeight) {
        if (slots <= 54) {
            return true;
        }
        if (scaledHeight >= 276) {
            if (slots <= 81) {
                return true;
            }
            if (scaledWidth >= 230 && slots <= 108) {
                return true;
            }
            if (scaledWidth >= 284 && slots <= 135) {
                return true;
            }
            if (scaledWidth >= 338 && slots <= 162) {
                return true;
            }
        }
        if (scaledWidth >= 338) {
            if (scaledHeight >= 330 && slots <= 216) {
                return true;
            }
            return scaledHeight >= 384 && slots <= 270;
        }
        return false;
    }

    @Nullable
    public static ScreenSize getScreenSize(ResourceLocation type, int slots, int scaledWidth, int scaledHeight) {
        if (Utils.PAGINATED_SCREEN_TYPE.equals((Object)type)) {
            return PageScreen.retrieveScreenSize(slots, scaledWidth, scaledHeight);
        }
        if (Utils.SCROLLABLE_SCREEN_TYPE.equals((Object)type)) {
            return ScrollScreen.retrieveScreenSize(slots, scaledWidth, scaledHeight);
        }
        if (Utils.SINGLE_SCREEN_TYPE.equals((Object)type)) {
            return SingleScreen.retrieveScreenSize(slots, scaledWidth, scaledHeight);
        }
        if (Utils.MINI_STORAGE_SCREEN_TYPE.equals((Object)type)) {
            return MiniStorageScreen.retrieveScreenSize(slots, scaledWidth, scaledHeight);
        }
        return null;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    public final boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.handleKeyPress(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (CommonClient.platformHelper().isConfigKeyPressed(keyCode, scanCode, modifiers) && ((AbstractHandler)this.f_97732_).getForcedScreenType() == null && CommonClient.platformHelper().configWrapper().getPreferredScreenType() != null) {
            this.f_96541_.m_91152_((Screen)new PickScreen(this));
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected boolean handleKeyPress(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    @NotNull
    @ApiStatus.OverrideOnly
    public List<Rect2i> getExclusionZones() {
        return List.of();
    }

    public int getInventoryWidth() {
        return this.inventoryWidth;
    }
}

